# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- CheckpointData
#'
#'     ``CheckpointData`` persists data to disk as well as memory.
#'     
#'         Storage level is MEMORY_AND_DISK if true, else MEMORY_ONLY.
#'         The default is false (MEMORY_ONLY).
#'     
#'         Use the removeCheckpoint parameter to reverse the cache operation.
#' @param diskIncluded Persist to disk as well as memory
#' @param removeCheckpoint Unpersist a cached dataset
#' @export
ml_checkpoint_data <- function(x, diskIncluded=FALSE, removeCheckpoint=FALSE)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.CheckpointData"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setDiskIncluded", as.logical(diskIncluded)) %>%
    invoke("setRemoveCheckpoint", as.logical(removeCheckpoint))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
