# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- CNTKModel
#'
#' 
#' @param inputCol The name of the input column
#' @param inputNode Index of the input node
#' @param miniBatcher Minibatcher to use
#' @param model Array of bytes containing the serialized CNTKModel
#' @param outputCol The name of the output column
#' @param outputNodeIndex Index of the output node
#' @param outputNodeName Name of the output node
#' @export
ml_cntkmodel <- function(x, inputCol=NULL, inputNode=0, miniBatcher=NULL, model=NULL, outputCol=NULL, outputNodeIndex=NULL, outputNodeName=NULL)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.CNTKModel"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setInputNode", as.integer(inputNode)) %>%
    invoke("setMiniBatcher", miniBatcher) %>%
    invoke("setModel", model) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setOutputNodeIndex", as.integer(outputNodeIndex)) %>%
    invoke("setOutputNodeName", outputNodeName)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
