# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- CNTKModel
#'
#' 
#' @param batchInput whether to use a batcher
#' @param convertOutputToDenseVector whether to convert the output to dense vectors
#' @param feedDict  Map of CNTK Variable names (keys) and Column Names (values)
#' @param fetchDict  Map of Column Names (keys) and CNTK Variable names (values)
#' @param miniBatcher Minibatcher to use
#' @param model Array of bytes containing the serialized CNTKModel
#' @param shapeOutput whether to shape the output
#' @export
ml_cntkmodel <- function(x, batchInput=TRUE, convertOutputToDenseVector=TRUE, feedDict="Map(ARGUMENT_0 -> ARGUMENT_0)", fetchDict="Map(OUTPUT_0 -> OUTPUT_0)", miniBatcher=NULL, model=NULL, shapeOutput=FALSE)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.CNTKModel"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setBatchInput", as.logical(batchInput)) %>%
    invoke("setConvertOutputToDenseVector", as.logical(convertOutputToDenseVector)) %>%
    invoke("setFeedDict", feedDict) %>%
    invoke("setFetchDict", fetchDict) %>%
    invoke("setMiniBatcher", miniBatcher) %>%
    invoke("setModel", model) %>%
    invoke("setShapeOutput", as.logical(shapeOutput))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
