# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- ComputeModelStatistics
#'
#'     ``ComputeModelStatistics`` returns the specified statistics on all the
#'         models specified
#'     
#'         The possible metrics are:
#'     
#'         Binary Classifiers:
#'     
#'         - "AreaUnderROC"
#'         - "AUC"
#'         - "accuracy"
#'         - "recall"
#'         - "all"
#'     
#'         Regression Classifiers:
#'     
#'         - "mse"
#'         - "rmse"
#'         - "r2"
#'         - "all"
#' @param evaluationMetric Metric to evaluate models with
#' @param labelCol The name of the label column
#' @param scoredLabelsCol Scored labels column name, only required if using SparkML estimators
#' @param scoresCol Scores or raw prediction column name, only required if using SparkML estimators
#' @export
ml_compute_model_statistics <- function(x, evaluationMetric="all", labelCol=NULL, scoredLabelsCol=NULL, scoresCol=NULL)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.ComputeModelStatistics"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setEvaluationMetric", evaluationMetric) %>%
    invoke("setLabelCol", labelCol) %>%
    invoke("setScoredLabelsCol", scoredLabelsCol) %>%
    invoke("setScoresCol", scoresCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
