# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- ComputePerInstanceStatistics
#'
#'     Evaluates the given scored dataset with per instance metrics.
#'     
#'         The Regression metrics are:
#'     
#'         - "L1_loss"
#'         - "L2_loss"
#'     
#'         The Classification metrics are:
#'     
#'         - "log_loss"
#' @param evaluationMetric Metric to evaluate models with
#' @param labelCol The name of the label column
#' @param scoredLabelsCol Scored labels column name, only required if using SparkML estimators
#' @param scoredProbabilitiesCol Scored probabilities, usually calibrated from raw scores, only required if using SparkML estimators
#' @param scoresCol Scores or raw prediction column name, only required if using SparkML estimators
#' @export
ml_compute_per_instance_statistics <- function(x, evaluationMetric="all", labelCol=NULL, scoredLabelsCol=NULL, scoredProbabilitiesCol=NULL, scoresCol=NULL)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.ComputePerInstanceStatistics"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setEvaluationMetric", evaluationMetric) %>%
    invoke("setLabelCol", labelCol) %>%
    invoke("setScoredLabelsCol", scoredLabelsCol) %>%
    invoke("setScoredProbabilitiesCol", scoredProbabilitiesCol) %>%
    invoke("setScoresCol", scoresCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
