# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- DynamicMiniBatchTransformer
#'
#' 
#' @param maxBatchSize The max size of the buffer
#' @export
ml_dynamic_mini_batch_transformer <- function(x, maxBatchSize=2147483647)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.DynamicMiniBatchTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setMaxBatchSize", as.integer(maxBatchSize))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
