# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- FindBestModel
#'
#'     Evaluates and chooses the best model from a list of models.
#' @param evaluationMetric Metric to evaluate models with
#' @param models List of models to be evaluated
#' @export
ml_find_best_model <- function(x, evaluationMetric="accuracy", models=NULL, only.model=FALSE)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.FindBestModel"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setEvaluationMetric", evaluationMetric) %>%
    invoke("setModels", models)
  mod_model_raw <- mod_parameterized %>%
    invoke("fit", df)

  mod_model <- sparklyr:::new_ml_model(mod_parameterized, mod_model_raw, mod_model_raw)

  if (only.model)
    return(mod_model)

  transformed <- invoke(mod_model$model, "transform", df)

  sdf_register(transformed)
}
