# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- FlattenBatch
#'
#' 
#' 
#' @export
ml_flatten_batch <- function(x)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.FlattenBatch"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%


  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
