# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- MultiNGram
#'
#' 
#' @param inputCol The name of the input column
#' @param lengths the collection of lengths to use for ngram extraction
#' @param outputCol The name of the output column
#' @export
ml_multi_ngram <- function(x, inputCol=NULL, lengths=NULL, outputCol=NULL)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.MultiNGram"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setLengths", lengths) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
