# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- PartitionConsolidator
#'
#' 
#' @param backoffTiming times to use in backoffs
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param handlingStrategy Which strategy to use when handling requests
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @export
ml_partition_consolidator <- function(x, backoffTiming="[I@16558482", concurrency=1, concurrentTimeout=100.0, handlingStrategy="advanced", inputCol=NULL, outputCol=NULL)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.PartitionConsolidator"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setBackoffTiming", backoffTiming) %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setHandlingStrategy", handlingStrategy) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
