# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- UDFTransformer
#'
#' 
#' @param inputCol The name of the input column
#' @param inputCols The names of the input columns
#' @param outputCol The name of the output column
#' @param udf User Defined Python Function to be applied to the DF input col
#' @param udfScala User Defined Function to be applied to the DF input col
#' @export
ml_udftransformer <- function(x, inputCol=NULL, inputCols=NULL, outputCol=NULL, udf=NULL, udfScala=NULL)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.UDFTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setInputCols", as.array(inputCols)) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setUdf", udf) %>%
    invoke("setUdfScala", udfScala)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
