# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- UnrollImage
#'
#'     Converts the representation of an m * n pixel image to an m * n vector
#'         of double.
#'     
#'         The parameter "inputCol" indicates the column containing the image; its
#'         default name is "image".  The default name for "outputCol", which holds
#'         the resultant vector is "<uid>_output".
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @export
ml_unroll_image <- function(x, inputCol="image", outputCol=NULL)
{
  df <- spark_dataframe(x)
  sc <- spark_connection(df)
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.UnrollImage"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
