# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- ClassBalancer
#'
#' 
#' @param broadcastJoin Whether to broadcast the class to weight mapping to the worker
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @export
ml_class_balancer <- function(x, broadcastJoin=TRUE, inputCol=NULL, outputCol="weight", unfit.model=FALSE, only.model=FALSE)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.ClassBalancer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setBroadcastJoin", as.logical(broadcastJoin)) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol)
  if (unfit.model)
    return(mod_parameterized)
  mod_model_raw <- mod_parameterized %>%
    invoke("fit", df)

  mod_model <- sparklyr:::new_ml_model(mod_parameterized, mod_model_raw, mod_model_raw)

  if (only.model)
    return(mod_model)

  transformed <- invoke(mod_model$model, "transform", df)

  sdf_register(transformed)
}
