# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- CustomOutputParser
#'
#' 
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @param udfPython User Defined Python Function to be applied to the DF input col
#' @param udfScala User Defined Function to be applied to the DF input col
#' @export
ml_custom_output_parser <- function(x, inputCol=NULL, outputCol=NULL, udfPython=NULL, udfScala=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.CustomOutputParser"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setUdfPython", udfPython) %>%
    invoke("setUdfScala", udfScala)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
