# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- DataConversion
#'
#'     Converts the specified list of columns to the specified type.  The types
#'         are specified by the following strings:
#'     
#'         - "boolean"
#'         - "byte"
#'         - "short"
#'         - "integer"
#'         - "long"
#'         - "float"
#'         - "double"
#'         - "string"
#'         - "toCategorical" - make the column be a categorical column
#'         - "clearCategorical" - clear the categorical column
#'         - "date" - the default date format is: "yyyy-MM-dd HH:mm:ss"
#' @param cols Comma separated list of columns whose type will be converted
#' @param convertTo The result type
#' @param dateTimeFormat Format for DateTime when making DateTime:String conversions
#' @export
ml_data_conversion <- function(x, cols=NULL, convertTo="", dateTimeFormat="yyyy-MM-dd HH:mm:ss")
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.DataConversion"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setCols", as.array(cols)) %>%
    invoke("setConvertTo", convertTo) %>%
    invoke("setDateTimeFormat", dateTimeFormat)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
