# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- DropColumns
#'
#' 
#' @param cols Comma separated list of column names
#' @export
ml_drop_columns <- function(x, cols=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.DropColumns"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setCols", as.array(cols))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
