# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- TimeIntervalMiniBatchTransformer
#'
#' 
#' @param maxBatchSize The max size of the buffer
#' @param millisToWait The time to wait before constructing a batch
#' @export
ml_time_interval_mini_batch_transformer <- function(x, maxBatchSize=2147483647, millisToWait=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.TimeIntervalMiniBatchTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setMaxBatchSize", as.integer(maxBatchSize)) %>%
    invoke("setMillisToWait", as.integer(millisToWait))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
