# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- VerifyFaces
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param errorCol column to hold http errors
#' @param faceId faceId of the face, comes from Face - Detect.
#' @param faceId1 faceId of one face, comes from Face - Detect.
#' @param faceId2 faceId of another face, comes from Face - Detect.
#' @param handler Which strategy to use when handling requests
#' @param largePersonGroupId Using existing largePersonGroupId and personId for fast ading a specified person. largePersonGroupId is created in LargePersonGroup - Create. Parameter personGroupId and largePersonGroupId should not be provided at the same time.
#' @param outputCol The name of the output column
#' @param personGroupId Using existing personGroupId and personId for fast loading a specified person. personGroupId is created in PersonGroup - Create. Parameter personGroupId and largePersonGroupId should not be provided at the same time.
#' @param personId Specify a certain person in a person group or a large person group. personId is created in PersonGroup Person - Create or LargePersonGroup Person - Create.
#' @param subscriptionKey the API key to use
#' @param url Url of the service
#' @export
ml_verify_faces <- function(x, concurrency=1, concurrentTimeout=100.0, errorCol=NULL, faceId=NULL, faceId1=NULL, faceId2=NULL, handler="UserDefinedFunction(<function2>,StringType,None)", largePersonGroupId=NULL, outputCol=NULL, personGroupId=NULL, personId=NULL, subscriptionKey=NULL, url=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.VerifyFaces"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setErrorCol", errorCol) %>%
    invoke("setFaceId", faceId) %>%
    invoke("setFaceId1", faceId1) %>%
    invoke("setFaceId2", faceId2) %>%
    invoke("setHandler", handler) %>%
    invoke("setLargePersonGroupId", largePersonGroupId) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setPersonGroupId", personGroupId) %>%
    invoke("setPersonId", personId) %>%
    invoke("setSubscriptionKey", subscriptionKey) %>%
    invoke("setUrl", url)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
