# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- Cacher
#'
#' 
#' @param disable Whether or disable caching (so that you can turn it off during evaluation)
#' @export
ml_cacher <- function(x, disable=FALSE)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.Cacher"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setDisable", as.logical(disable))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
