# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- ImageTransformer
#'
#' 
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @param stages Image transformation stages
#' @export
ml_image_transformer <- function(x, inputCol="image", outputCol=NULL, stages=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.ImageTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setStages", stages)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
