# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- RecognizeDomainSpecificContent
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param errorCol column to hold http errors
#' @param handler Which strategy to use when handling requests
#' @param imageUrl the url of the image to use
#' @param model the domain specific model: celebrities, landmarks
#' @param outputCol The name of the output column
#' @param subscriptionKey the API key to use
#' @param url Url of the service
#' @export
ml_recognize_domain_specific_content <- function(x, concurrency=1, concurrentTimeout=100.0, errorCol=NULL, handler="UserDefinedFunction(<function2>,StringType,None)", imageUrl=NULL, model=NULL, outputCol=NULL, subscriptionKey=NULL, url=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.RecognizeDomainSpecificContent"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setErrorCol", errorCol) %>%
    invoke("setHandler", handler) %>%
    invoke("setImageUrl", imageUrl) %>%
    invoke("setModel", model) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setSubscriptionKey", subscriptionKey) %>%
    invoke("setUrl", url)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
