# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- Repartition
#'
#'     Partitions the dataset into n partitions.  Default value for n is 10.
#' @param disable Whether to disable repartitioning (so that one can turn it off for evaluation)
#' @param n Number of partitions
#' @export
ml_repartition <- function(x, disable=FALSE, n=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.Repartition"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setDisable", as.logical(disable)) %>%
    invoke("setN", as.integer(n))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
