# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- ResizeImageTransformer
#'
#' 
#' @param height the width of the image
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @param width the width of the image
#' @export
ml_resize_image_transformer <- function(x, height=NULL, inputCol="image", outputCol=NULL, width=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.ResizeImageTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setHeight", as.integer(height)) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setWidth", as.integer(width))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
