# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- SimpleHTTPTransformer
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param errorCol column to hold http errors
#' @param flattenOutputBatches whether to flatten the output batches
#' @param handler Which strategy to use when handling requests
#' @param inputCol The name of the input column
#' @param inputParser format to parse the column to
#' @param miniBatcher Minibatcher to use
#' @param outputCol The name of the output column
#' @param outputParser format to parse the column to
#' @export
ml_simple_httptransformer <- function(x, concurrency=1, concurrentTimeout=100.0, errorCol=NULL, flattenOutputBatches=NULL, handler="UserDefinedFunction(<function2>,StringType,None)", inputCol=NULL, inputParser=NULL, miniBatcher=NULL, outputCol=NULL, outputParser=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.SimpleHTTPTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setErrorCol", errorCol) %>%
    invoke("setFlattenOutputBatches", as.logical(flattenOutputBatches)) %>%
    invoke("setHandler", handler) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setInputParser", inputParser) %>%
    invoke("setMiniBatcher", miniBatcher) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setOutputParser", outputParser)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
