# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- Timer
#'
#' 
#' @param disableMaterialization Whether to disable timing (so that one can turn it off for evaluation)
#' @param logToScala Whether to output the time to the scala console
#' @param stage The stage to time
#' @export
ml_timer <- function(x, disableMaterialization=TRUE, logToScala=TRUE, stage=NULL, unfit.model=FALSE, only.model=FALSE)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.Timer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setDisableMaterialization", as.logical(disableMaterialization)) %>%
    invoke("setLogToScala", as.logical(logToScala)) %>%
    invoke("setStage", stage)
  if (unfit.model)
    return(mod_parameterized)
  mod_model_raw <- mod_parameterized %>%
    invoke("fit", df)

  mod_model <- sparklyr:::new_ml_model(mod_parameterized, mod_model_raw, mod_model_raw)

  if (only.model)
    return(mod_model)

  transformed <- invoke(mod_model$model, "transform", df)

  sdf_register(transformed)
}
