# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- FastVectorAssembler
#'
#'     A fast vector assembler.  The columns given must be ordered such that
#'         categorical columns come first.  Otherwise, Spark learners will give
#'         categorical attributes to the wrong index.  The assembler does not keep
#'         spurious numeric data which can significantly slow down computations
#'         when there are millions of columns.
#'     
#'         To use this ``FastVectorAssemble`` you must import the
#'         ``org.apache.spark.ml.feature`` package.
#' @param inputCols input column names
#' @param outputCol output column name
#' @export
ml_fast_vector_assembler <- function(x, inputCols=NULL, outputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "org.apache.spark.ml.feature.FastVectorAssembler"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCols", as.array(inputCols)) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
