# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- FixedMiniBatchTransformer
#'
#' 
#' @param batchSize The max size of the buffer
#' @param buffered Whether or not to buffer batches in memory
#' @param maxBufferSize The max size of the buffer
#' @export
ml_fixed_mini_batch_transformer <- function(x, batchSize=NULL, buffered=FALSE, maxBufferSize=2147483647)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.FixedMiniBatchTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setBatchSize", as.integer(batchSize)) %>%
    invoke("setBuffered", as.logical(buffered)) %>%
    invoke("setMaxBufferSize", as.integer(maxBufferSize))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
