# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- JSONInputParser
#'
#' 
#' @param headers headers of the request
#' @param inputCol The name of the input column
#' @param method method to use for request, (PUT, POST, PATCH)
#' @param outputCol The name of the output column
#' @param url Url of the service
#' @export
ml_jsoninput_parser <- function(x, headers="Map()", inputCol=NULL, method="POST", outputCol=NULL, url=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.JSONInputParser"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setHeaders", headers) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setMethod", method) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setUrl", url)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
