# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- RankingTrainValidationSplitModel
#'
#' 
#' @param bestModel The internal ALS model used splitter
#' @param validationMetrics Best Model
#' @export
ml_ranking_train_validation_split_model <- function(x, bestModel=NULL, validationMetrics=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.RankingTrainValidationSplitModel"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setBestModel", bestModel) %>%
    invoke("setValidationMetrics", validationMetrics)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
