# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- SuperpixelTransformer
#'
#' 
#' @param cellSize Number that controls the size of the superpixels
#' @param inputCol The name of the input column
#' @param modifier Controls the trade-off spatial and color distance
#' @param outputCol The name of the output column
#' @export
ml_superpixel_transformer <- function(x, cellSize=16.0, inputCol=NULL, modifier=130.0, outputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.SuperpixelTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setCellSize", as.double(cellSize)) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setModifier", as.double(modifier)) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
