# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- ValueIndexerModel
#'
#'     Model produced by ``ValueIndexer``.
#' @param dataType The datatype of the levels as a Json string
#' @param inputCol The name of the input column
#' @param levels Levels in categorical array
#' @param outputCol The name of the output column
#' @export
ml_value_indexer_model <- function(x, dataType="string", inputCol="input", levels=NULL, outputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.ValueIndexerModel"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setDataType", dataType) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setLevels", levels) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
