# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- GenerateThumbnails
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param errorCol column to hold http errors
#' @param handler Which strategy to use when handling requests
#' @param height the desired height of the image
#' @param imageBytes bytestream of the image to use
#' @param imageUrl the url of the image to use
#' @param outputCol The name of the output column
#' @param smartCropping whether to intelligently crop the image
#' @param subscriptionKey the API key to use
#' @param timeout number of seconds to wait before closing the connection
#' @param url Url of the service
#' @param width the desired width of the image
#' @export
ml_generate_thumbnails <- function(x, concurrency=1, concurrentTimeout=100.0, errorCol=NULL, handler="UserDefinedFunction(<function2>,StringType,None)", height=NULL, imageBytes=NULL, imageUrl=NULL, outputCol=NULL, smartCropping=NULL, subscriptionKey=NULL, timeout=60.0, url=NULL, width=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.GenerateThumbnails"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setErrorCol", errorCol) %>%
    invoke("setHandler", handler) %>%
    invoke("setHeight", height) %>%
    invoke("setImageBytes", imageBytes) %>%
    invoke("setImageUrl", imageUrl) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setSmartCropping", smartCropping) %>%
    invoke("setSubscriptionKey", subscriptionKey) %>%
    invoke("setTimeout", as.double(timeout)) %>%
    invoke("setUrl", url) %>%
    invoke("setWidth", width)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
