# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- OCR
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param detectOrientation whether to detect image orientation prior to processing
#' @param errorCol column to hold http errors
#' @param handler Which strategy to use when handling requests
#' @param imageBytes bytestream of the image to use
#' @param imageUrl the url of the image to use
#' @param language the language to use
#' @param outputCol The name of the output column
#' @param subscriptionKey the API key to use
#' @param timeout number of seconds to wait before closing the connection
#' @param url Url of the service
#' @export
ml_ocr <- function(x, concurrency=1, concurrentTimeout=100.0, detectOrientation=NULL, errorCol=NULL, handler="UserDefinedFunction(<function2>,StringType,None)", imageBytes=NULL, imageUrl=NULL, language=NULL, outputCol=NULL, subscriptionKey=NULL, timeout=60.0, url=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.OCR"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setDetectOrientation", detectOrientation) %>%
    invoke("setErrorCol", errorCol) %>%
    invoke("setHandler", handler) %>%
    invoke("setImageBytes", imageBytes) %>%
    invoke("setImageUrl", imageUrl) %>%
    invoke("setLanguage", language) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setSubscriptionKey", subscriptionKey) %>%
    invoke("setTimeout", as.double(timeout)) %>%
    invoke("setUrl", url)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
