# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- PartitionConsolidator
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @param timeout number of seconds to wait before closing the connection
#' @export
ml_partition_consolidator <- function(x, concurrency=1, concurrentTimeout=100.0, inputCol=NULL, outputCol=NULL, timeout=60.0)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.PartitionConsolidator"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setTimeout", as.double(timeout))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
