# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- RankingEvaluator
#'
#' 
#' @param itemCol Column of items
#' @param k number of items
#' @param labelCol label column name
#' @param metricName metric name in evaluation (ndcgAt|map|precisionAtk|recallAtK|diversityAtK|maxDiversity|mrr|fcp)
#' @param nItems number of items
#' @param predictionCol prediction column name
#' @param ratingCol Column of ratings
#' @param userCol Column of users
#' @export
ml_ranking_evaluator <- function(x, itemCol=NULL, k=10, labelCol="label", metricName="ndcgAt", nItems=-1, predictionCol="prediction", ratingCol=NULL, userCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.RankingEvaluator"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setItemCol", itemCol) %>%
    invoke("setK", as.integer(k)) %>%
    invoke("setLabelCol", labelCol) %>%
    invoke("setMetricName", metricName) %>%
    invoke("setNItems", as.integer(nItems)) %>%
    invoke("setPredictionCol", predictionCol) %>%
    invoke("setRatingCol", ratingCol) %>%
    invoke("setUserCol", userCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
