# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- TextPreprocessor
#'
#' 
#' @param inputCol The name of the input column
#' @param map Map of substring match to replacement
#' @param normFunc Name of normalization function to apply
#' @param outputCol The name of the output column
#' @export
ml_text_preprocessor <- function(x, inputCol=NULL, map=NULL, normFunc=NULL, outputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.TextPreprocessor"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setMap", map) %>%
    invoke("setNormFunc", normFunc) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
