# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- UnicodeNormalize
#'
#' 
#' @param form Unicode normalization form: NFC, NFD, NFKC, NFKD
#' @param inputCol The name of the input column
#' @param lower Lowercase text
#' @param outputCol The name of the output column
#' @export
ml_unicode_normalize <- function(x, form=NULL, inputCol=NULL, lower=NULL, outputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.UnicodeNormalize"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setForm", form) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setLower", as.logical(lower)) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
