# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- DetectFace
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param errorCol column to hold http errors
#' @param handler Which strategy to use when handling requests
#' @param imageUrl the url of the image to use
#' @param outputCol The name of the output column
#' @param returnFaceAttributes Analyze and return the one or more specified face attributes Supported face attributes include: age, gender, headPose, smile, facialHair, glasses, emotion, hair, makeup, occlusion, accessories, blur, exposure and noise. Face attribute analysis has additional computational and time cost.
#' @param returnFaceId Return faceIds of the detected faces or not. The default value is true
#' @param returnFaceLandmarks Return face landmarks of the detected faces or not. The default value is false.
#' @param subscriptionKey the API key to use
#' @param timeout number of seconds to wait before closing the connection
#' @param url Url of the service
#' @export
ml_detect_face <- function(x, concurrency=1, concurrentTimeout=100.0, errorCol=NULL, handler="UserDefinedFunction(<function2>,StringType,None)", imageUrl=NULL, outputCol=NULL, returnFaceAttributes=NULL, returnFaceId=NULL, returnFaceLandmarks=NULL, subscriptionKey=NULL, timeout=60.0, url=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.DetectFace"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setErrorCol", errorCol) %>%
    invoke("setHandler", handler) %>%
    invoke("setImageUrl", imageUrl) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setReturnFaceAttributes", returnFaceAttributes) %>%
    invoke("setReturnFaceId", returnFaceId) %>%
    invoke("setReturnFaceLandmarks", returnFaceLandmarks) %>%
    invoke("setSubscriptionKey", subscriptionKey) %>%
    invoke("setTimeout", as.double(timeout)) %>%
    invoke("setUrl", url)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
