# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- HTTPTransformer
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param handler Which strategy to use when handling requests
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @param timeout number of seconds to wait before closing the connection
#' @export
ml_httptransformer <- function(x, concurrency=1, concurrentTimeout=100.0, handler="UserDefinedFunction(<function2>,StringType,None)", inputCol=NULL, outputCol=NULL, timeout=60.0)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.HTTPTransformer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setHandler", handler) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setTimeout", as.double(timeout))

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
