# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- ImageSetAugmenter
#'
#' 
#' @param flipLeftRight Symmetric Left-Right
#' @param flipUpDown Symmetric Up-Down
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @export
ml_image_set_augmenter <- function(x, flipLeftRight=TRUE, flipUpDown=FALSE, inputCol="image", outputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.ImageSetAugmenter"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setFlipLeftRight", as.logical(flipLeftRight)) %>%
    invoke("setFlipUpDown", as.logical(flipUpDown)) %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
