# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- IndexToValue
#'
#'     The ``IndexToValue`` class takes in a categorical column with MML-style
#'         attributes and then transforms it back to the original values.  This
#'         extends MLLIB ``IndexToString`` by allowing the transformation back to
#'         any types of values.
#' @param inputCol The name of the input column
#' @param outputCol The name of the output column
#' @export
ml_index_to_value <- function(x, inputCol=NULL, outputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.IndexToValue"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setInputCol", inputCol) %>%
    invoke("setOutputCol", outputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
