# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- KeyPhraseExtractor
#'
#' 
#' @param concurrency max number of concurrent calls
#' @param concurrentTimeout max number seconds to wait on futures if concurrency >= 1
#' @param errorCol column to hold http errors
#' @param handler Which strategy to use when handling requests
#' @param language the language code of the text (optional for some services)
#' @param outputCol The name of the output column
#' @param subscriptionKey the API key to use
#' @param text the text in the request body
#' @param timeout number of seconds to wait before closing the connection
#' @param url Url of the service
#' @export
ml_key_phrase_extractor <- function(x, concurrency=1, concurrentTimeout=100.0, errorCol=NULL, handler="UserDefinedFunction(<function2>,StringType,None)", language="ServiceParamData(None,Some(List(en)))", outputCol=NULL, subscriptionKey=NULL, text="ServiceParamData(Some(Right(text)),None)", timeout=60.0, url=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.KeyPhraseExtractor"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setConcurrency", as.integer(concurrency)) %>%
    invoke("setConcurrentTimeout", as.double(concurrentTimeout)) %>%
    invoke("setErrorCol", errorCol) %>%
    invoke("setHandler", handler) %>%
    invoke("setLanguage", language) %>%
    invoke("setOutputCol", outputCol) %>%
    invoke("setSubscriptionKey", subscriptionKey) %>%
    invoke("setText", text) %>%
    invoke("setTimeout", as.double(timeout)) %>%
    invoke("setUrl", url)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
