# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- RecommendationIndexerModel
#'
#' 
#' @param itemIndexModel itemIndexModel
#' @param itemInputCol Item Input Col
#' @param itemOutputCol Item Output Col
#' @param ratingCol Rating Col
#' @param userIndexModel userIndexModel
#' @param userInputCol User Input Col
#' @param userOutputCol User Output Col
#' @export
ml_recommendation_indexer_model <- function(x, itemIndexModel=NULL, itemInputCol=NULL, itemOutputCol=NULL, ratingCol=NULL, userIndexModel=NULL, userInputCol=NULL, userOutputCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.RecommendationIndexerModel"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setItemIndexModel", itemIndexModel) %>%
    invoke("setItemInputCol", itemInputCol) %>%
    invoke("setItemOutputCol", itemOutputCol) %>%
    invoke("setRatingCol", ratingCol) %>%
    invoke("setUserIndexModel", userIndexModel) %>%
    invoke("setUserInputCol", userInputCol) %>%
    invoke("setUserOutputCol", userOutputCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
