# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- Lambda
#'
#' 
#' @param transformFunc holder for dataframe function
#' @param transformSchemaFunc the output schema after the transformation
#' @export
ml_lambda <- function(x, transformFunc=NULL, transformSchemaFunc=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.Lambda"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setTransformFunc", transformFunc) %>%
    invoke("setTransformSchemaFunc", transformSchemaFunc)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
