# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- RankingAdapterModel
#'
#' 
#' @param itemCol Column of items
#' @param k number of items
#' @param labelCol The name of the label column
#' @param minRatingsPerItem min ratings for items > 0
#' @param minRatingsPerUser min ratings for users > 0
#' @param mode recommendation mode
#' @param ratingCol Column of ratings
#' @param recommender estimator for selection
#' @param recommenderModel recommenderModel
#' @param userCol Column of users
#' @export
ml_ranking_adapter_model <- function(x, itemCol=NULL, k=10, labelCol="label", minRatingsPerItem=1, minRatingsPerUser=1, mode="allUsers", ratingCol=NULL, recommender=NULL, recommenderModel=NULL, userCol=NULL)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.RankingAdapterModel"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setItemCol", itemCol) %>%
    invoke("setK", as.integer(k)) %>%
    invoke("setLabelCol", labelCol) %>%
    invoke("setMinRatingsPerItem", as.integer(minRatingsPerItem)) %>%
    invoke("setMinRatingsPerUser", as.integer(minRatingsPerUser)) %>%
    invoke("setMode", mode) %>%
    invoke("setRatingCol", ratingCol) %>%
    invoke("setRecommender", recommender) %>%
    invoke("setRecommenderModel", recommenderModel) %>%
    invoke("setUserCol", userCol)

  transformed <- invoke(mod_parameterized, "transform", df)

  sdf_register(transformed)
}
