# Copyright (C) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See LICENSE in project root for information.

#' Spark ML -- RecommendationIndexer
#'
#' 
#' @param itemInputCol Item Input Col
#' @param itemOutputCol Item Output Col
#' @param ratingCol Rating Col
#' @param userInputCol User Input Col
#' @param userOutputCol User Output Col
#' @export
ml_recommendation_indexer <- function(x, itemInputCol=NULL, itemOutputCol=NULL, ratingCol=NULL, userInputCol=NULL, userOutputCol=NULL, unfit.model=FALSE, only.model=FALSE)
{
  if (unfit.model) {
    sc <- x
  } else {
    df <- spark_dataframe(x)
    sc <- spark_connection(df)
  }
  env <- new.env(parent = emptyenv())

  env$model <- "com.microsoft.ml.spark.RecommendationIndexer"
  mod <- invoke_new(sc, env$model)

  mod_parameterized <- mod %>%
    invoke("setItemInputCol", itemInputCol) %>%
    invoke("setItemOutputCol", itemOutputCol) %>%
    invoke("setRatingCol", ratingCol) %>%
    invoke("setUserInputCol", userInputCol) %>%
    invoke("setUserOutputCol", userOutputCol)
  if (unfit.model)
    return(mod_parameterized)
  mod_model_raw <- mod_parameterized %>%
    invoke("fit", df)

  mod_model <- sparklyr:::new_ml_model(mod_parameterized, mod_model_raw, mod_model_raw)

  if (only.model)
    return(mod_model)

  transformed <- invoke(mod_model$model, "transform", df)

  sdf_register(transformed)
}
